import { configService } from "../../services/configService.js";
const normalizeBase = (base) => base.replace(/\/+$/, "");
const normalizePath = (path) => {
    if (!path) {
        return "";
    }
    return path.startsWith("/") ? path : `/${path}`;
};
export const getProxyBaseUrl = () => {
    const host = configService.getProxyHost();
    const port = configService.getProxyPort();
    return `http://${host}:${port}`;
};
export const buildProxyUrl = (path) => {
    return `${normalizeBase(getProxyBaseUrl())}${normalizePath(path)}`;
};
export const getBackendBaseUrl = () => {
    return configService.getBackendUrl();
};
export const buildBackendUrl = (path) => {
    return `${normalizeBase(getBackendBaseUrl())}${normalizePath(path)}`;
};
export const getOpenAIBackendBaseUrl = () => {
    return configService.getOpenAIBackendUrl();
};
export const buildOpenAIBackendUrl = (path) => {
    return `${normalizeBase(getOpenAIBackendBaseUrl())}${normalizePath(path)}`;
};
export const getOllamaBackendBaseUrl = () => {
    return configService.getOllamaBackendUrl();
};
export const buildOllamaBackendUrl = (path) => {
    return `${normalizeBase(getOllamaBackendBaseUrl())}${normalizePath(path)}`;
};
//# sourceMappingURL=index.js.map