/**
 * Proxy Utilities - SSOT for shared proxy middleware functionality
 *
 * Centralizes common logic used by both genericProxy and ollamaProxy:
 * - ProxyResponse type definition
 * - Backend headers collection
 * - ProxyRequest info construction
 */
/**
 * Extract original URL from incoming message
 */
export function getOriginalUrl(req, fallback) {
    const reqWithUrl = req;
    return reqWithUrl.originalUrl ?? reqWithUrl.url ?? fallback;
}
/**
 * Collect all headers from proxy request as a record
 * Converts number values to strings for consistency
 */
export function collectBackendHeaders(proxyReq) {
    const headers = {};
    for (const name of proxyReq.getHeaderNames()) {
        const value = proxyReq.getHeader(name);
        headers[name] = typeof value === "number" ? String(value) : value;
    }
    return headers;
}
/**
 * Build ProxyRequest info object for logging
 */
export function buildProxyRequestInfo(expressReq, backendUrl, body = undefined) {
    return {
        method: expressReq.method,
        headers: expressReq.headers,
        body,
        ip: expressReq.ip,
        originalUrl: backendUrl,
        path: backendUrl,
    };
}
//# sourceMappingURL=proxyUtils.js.map