const GENERIC_MESSAGE_ROLES = new Set([
    'system',
    'user',
    'assistant',
    'tool',
]);
/**
 * Type guard to check if value is a plain object (not array, not null)
 *
 * SSOT for object type checking across all converters.
 * Used for parameter normalization and validation.
 */
export const isRecord = (value) => typeof value === "object" && value !== null && !Array.isArray(value);
/**
 * Type guard to check if value is a string
 */
export const isString = (value) => typeof value === "string";
/**
 * Type guard to check if value is a number
 */
export const isNumber = (value) => typeof value === "number" && !Number.isNaN(value);
/**
 * Type guard to check if value is a boolean
 */
export const isBoolean = (value) => typeof value === "boolean";
/**
 * Type guard to check if value is an array
 */
export const isArray = (value) => Array.isArray(value);
/**
 * Type guard to check if value is null or undefined
 */
export const isNullish = (value) => value === null || value === undefined;
export const isGenericMessageRole = (value) => typeof value === 'string' && GENERIC_MESSAGE_ROLES.has(value);
//# sourceMappingURL=typeGuards.js.map