export function isOpenAIFormat(obj) {
    if (obj !== null && typeof obj === "object") {
        const record = obj;
        if (Array.isArray(record["messages"]) || Array.isArray(record["choices"])) {
            return true;
        }
        if (typeof record["object"] === "string" && record["object"] === "chat.completion.chunk" && Array.isArray(record["choices"])) {
            return true;
        }
    }
    return false;
}
//# sourceMappingURL=openai.js.map