/**
 * Translation Service Implementation
 *
 * SSOT for all format conversions. All handlers MUST use this service.
 * Direct converter imports in handlers are FORBIDDEN.
 */
import { setupStreamHandler } from '../handlers/streamingHandler.js';
import { translate, translateResponse } from '../translation/index.js';
import { configService } from './configService.js';
class TranslationServiceImpl {
    async translateRequest(request, from, to, toolNames) {
        const result = await translate({
            from,
            to,
            request,
            context: {
                knownToolNames: toolNames,
                enableXMLToolParsing: toolNames.length > 0,
                passTools: configService.shouldPassTools(),
                toolReinjection: configService.getToolReinjectionConfig(),
            },
        });
        if (!result.success) {
            throw result.error ?? new Error('Translation failed');
        }
        return result.data;
    }
    async translateResponse(response, from, to, toolNames) {
        const result = await translateResponse(response, from, to, {
            knownToolNames: toolNames,
            enableXMLToolParsing: toolNames.length > 0,
        });
        if (!result.success) {
            throw result.error ?? new Error('Response translation failed');
        }
        return result.data;
    }
    translateStream(_stream, _from, _to, _tools, _streamOptions) {
        // This is a simplified adapter - in practice we'd return a PassThrough stream
        // For now, we keep the existing setupStreamHandler pattern but will refactor
        throw new Error('Stream translation requires Response object - use setupStreamHandler directly for now');
    }
    /**
     * Temporary bridge method until we refactor streaming to not require Response
     */
    setupStreamTranslation(backendStream, res, clientFormat, backendFormat, tools, options) {
        setupStreamHandler(backendStream, res, clientFormat, backendFormat, tools, options?.streamOptions, options?.clientRequestBody);
    }
}
export const translationService = new TranslationServiceImpl();
//# sourceMappingURL=translationService.js.map