export function debug(debugMode, ...args) {
    if (debugMode) {
        try {
            process.stdout.write(args.map(a => String(a)).join(' ') + '\n');
        }
        catch {
            // fallback to noop
        }
    }
}
export function error(...args) {
    try {
        process.stderr.write(args.map(a => String(a)).join(' ') + '\n');
    }
    catch {
        // fallback to noop
    }
}
export function warn(...args) {
    try {
        process.stderr.write(args.map(a => String(a)).join(' ') + '\n');
    }
    catch {
        // fallback to noop
    }
}
export function info(...args) {
    try {
        process.stdout.write(args.map(a => String(a)).join(' ') + '\n');
    }
    catch {
        // fallback to noop
    }
}
export function createLogger(debugMode = false) {
    const isDebugEnabled = typeof debugMode === 'string' ? debugMode === 'true' : Boolean(debugMode);
    return {
        debug: (...args) => debug(isDebugEnabled, ...args),
        log: (...args) => debug(isDebugEnabled, ...args),
        error,
        warn,
        info,
    };
}
export default { debug, error, warn, info, createLogger };
//# sourceMappingURL=configLogger.js.map