export class WrapperAwareStreamProcessor {
    originalProcessor;
    constructor(originalProcessor) {
        this.originalProcessor = originalProcessor;
    }
    setTools(tools) {
        if (typeof this.originalProcessor.setTools === "function") {
            this.originalProcessor.setTools(tools ?? []);
        }
    }
    processChunk(chunk) {
        return this.originalProcessor.processChunk(chunk);
    }
    handleDone() {
        if (typeof this.originalProcessor.handleDone === "function") {
            this.originalProcessor.handleDone();
        }
    }
    end() {
        if (typeof this.originalProcessor.end === "function") {
            this.originalProcessor.end();
        }
    }
    closeStream(message = null) {
        if (typeof this.originalProcessor.closeStream === "function") {
            this.originalProcessor.closeStream(message);
        }
    }
    closeStreamWithError(errorMessage) {
        if (typeof this.originalProcessor.closeStreamWithError === "function") {
            this.originalProcessor.closeStreamWithError(errorMessage);
        }
    }
    pipeFrom(stream) {
        if (typeof this.originalProcessor.pipeFrom === "function") {
            this.originalProcessor.pipeFrom(stream);
            return;
        }
        stream.on("data", (chunk) => {
            void Promise.resolve(this.processChunk(chunk));
        });
        stream.on("end", () => {
            this.handleDone();
        });
        stream.on("error", (error) => {
            this.closeStreamWithError(error.message);
        });
    }
}
//# sourceMappingURL=wrapperAwareStreamProcessor.js.map