/**
 * OpenAI /v1/models Handler
 *
 * Backend-agnostic model listing with automatic format translation.
 * Returns OpenAI-formatted model lists regardless of the backend provider.
 */
import { logger } from '../logging/index.js';
import { modelService } from '../services/index.js';
import { sendHTTPError } from '../utils/http/errorResponseHandler.js';
import { getBackendContext, sendSuccessJSON } from '../utils/http/handlerUtils.js';
export default async function openaiModelsHandler(req, res) {
    try {
        const { backendMode, authHeader } = getBackendContext(req);
        logger.info(`[OPENAI MODELS] Listing models for backend=${backendMode}`);
        const response = await modelService.listModels('openai', authHeader);
        sendSuccessJSON(res, response, 'OPENAI MODELS');
    }
    catch (error) {
        sendHTTPError(res, error, 'OPENAI MODELS');
    }
}
//# sourceMappingURL=openaiModelsHandler.js.map