/**
 * OpenAI /v1/models/:model Handler
 *
 * Returns OpenAI-formatted model metadata for any backend provider.
 */
import { logger } from '../logging/index.js';
import { modelService } from '../services/index.js';
import { sendHTTPError, sendValidationError } from '../utils/http/errorResponseHandler.js';
import { getBackendContext, sendSuccessJSON } from '../utils/http/handlerUtils.js';
export default async function openaiModelInfoHandler(req, res) {
    const raw = req.params['model'] ?? req.params['modelId'];
    const modelId = Array.isArray(raw) ? raw[0] : raw;
    if (!modelId) {
        sendValidationError(res, 'Model identifier is required', 'OPENAI MODEL INFO');
        return;
    }
    try {
        const { backendMode, authHeader } = getBackendContext(req);
        logger.info(`[OPENAI MODEL INFO] Fetching model="${modelId}" for backend=${backendMode}`);
        const response = await modelService.getModelInfo(modelId, 'openai', authHeader);
        sendSuccessJSON(res, response, 'OPENAI MODEL INFO');
    }
    catch (error) {
        sendHTTPError(res, error, 'OPENAI MODEL INFO');
    }
}
//# sourceMappingURL=openaiModelInfoHandler.js.map