"use strict";
/* tslint:disable */
/* eslint-disable */
/* prettier-ignore */
/* auto-generated by NAPI-RS */
const { existsSync, readFileSync } = require('fs');
const { join } = require('path');
const { platform, arch } = process;
let nativeBinding = null;
let localFileExisted = false;
let loadError = null;
function isMusl() {
    // For Node 10
    if (!process.report || typeof process.report.getReport !== 'function') {
        try {
            const lddPath = require('child_process').execSync('which ldd').toString().trim();
            return readFileSync(lddPath, 'utf8').includes('musl');
        }
        catch (e) {
            return true;
        }
    }
    else {
        const { glibcVersionRuntime } = process.report.getReport().header;
        return !glibcVersionRuntime;
    }
}
switch (platform) {
    case 'android':
        switch (arch) {
            case 'arm64':
                localFileExisted = existsSync(join(__dirname, 'lancedb.android-arm64.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.android-arm64.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-android-arm64');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            case 'arm':
                localFileExisted = existsSync(join(__dirname, 'lancedb.android-arm-eabi.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.android-arm-eabi.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-android-arm-eabi');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            default:
                throw new Error(`Unsupported architecture on Android ${arch}`);
        }
        break;
    case 'win32':
        switch (arch) {
            case 'x64':
                localFileExisted = existsSync(join(__dirname, 'lancedb.win32-x64-msvc.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.win32-x64-msvc.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-win32-x64-msvc');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            case 'ia32':
                localFileExisted = existsSync(join(__dirname, 'lancedb.win32-ia32-msvc.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.win32-ia32-msvc.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-win32-ia32-msvc');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            case 'arm64':
                localFileExisted = existsSync(join(__dirname, 'lancedb.win32-arm64-msvc.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.win32-arm64-msvc.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-win32-arm64-msvc');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            default:
                throw new Error(`Unsupported architecture on Windows: ${arch}`);
        }
        break;
    case 'darwin':
        localFileExisted = existsSync(join(__dirname, 'lancedb.darwin-universal.node'));
        try {
            if (localFileExisted) {
                nativeBinding = require('./lancedb.darwin-universal.node');
            }
            else {
                nativeBinding = require('@lancedb/lancedb-darwin-universal');
            }
            break;
        }
        catch { }
        switch (arch) {
            case 'x64':
                localFileExisted = existsSync(join(__dirname, 'lancedb.darwin-x64.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.darwin-x64.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-darwin-x64');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            case 'arm64':
                localFileExisted = existsSync(join(__dirname, 'lancedb.darwin-arm64.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.darwin-arm64.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-darwin-arm64');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            default:
                throw new Error(`Unsupported architecture on macOS: ${arch}`);
        }
        break;
    case 'freebsd':
        if (arch !== 'x64') {
            throw new Error(`Unsupported architecture on FreeBSD: ${arch}`);
        }
        localFileExisted = existsSync(join(__dirname, 'lancedb.freebsd-x64.node'));
        try {
            if (localFileExisted) {
                nativeBinding = require('./lancedb.freebsd-x64.node');
            }
            else {
                nativeBinding = require('@lancedb/lancedb-freebsd-x64');
            }
        }
        catch (e) {
            loadError = e;
        }
        break;
    case 'linux':
        switch (arch) {
            case 'x64':
                if (isMusl()) {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-x64-musl.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-x64-musl.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-x64-musl');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                else {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-x64-gnu.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-x64-gnu.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-x64-gnu');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                break;
            case 'arm64':
                if (isMusl()) {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-arm64-musl.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-arm64-musl.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-arm64-musl');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                else {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-arm64-gnu.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-arm64-gnu.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-arm64-gnu');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                break;
            case 'arm':
                if (isMusl()) {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-arm-musleabihf.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-arm-musleabihf.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-arm-musleabihf');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                else {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-arm-gnueabihf.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-arm-gnueabihf.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-arm-gnueabihf');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                break;
            case 'riscv64':
                if (isMusl()) {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-riscv64-musl.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-riscv64-musl.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-riscv64-musl');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                else {
                    localFileExisted = existsSync(join(__dirname, 'lancedb.linux-riscv64-gnu.node'));
                    try {
                        if (localFileExisted) {
                            nativeBinding = require('./lancedb.linux-riscv64-gnu.node');
                        }
                        else {
                            nativeBinding = require('@lancedb/lancedb-linux-riscv64-gnu');
                        }
                    }
                    catch (e) {
                        loadError = e;
                    }
                }
                break;
            case 's390x':
                localFileExisted = existsSync(join(__dirname, 'lancedb.linux-s390x-gnu.node'));
                try {
                    if (localFileExisted) {
                        nativeBinding = require('./lancedb.linux-s390x-gnu.node');
                    }
                    else {
                        nativeBinding = require('@lancedb/lancedb-linux-s390x-gnu');
                    }
                }
                catch (e) {
                    loadError = e;
                }
                break;
            default:
                throw new Error(`Unsupported architecture on Linux: ${arch}`);
        }
        break;
    default:
        throw new Error(`Unsupported OS: ${platform}, architecture: ${arch}`);
}
if (!nativeBinding) {
    if (loadError) {
        throw loadError;
    }
    throw new Error(`Failed to load native binding`);
}
const { Connection, JsHeaderProvider, Index, RecordBatchIterator, NativeMergeInsertBuilder, PermutationBuilder, permutationBuilder, Query, VectorQuery, TakeQuery, JsFullTextQuery, Reranker, RrfReranker, Session, Table, TagContents, Tags } = nativeBinding;
module.exports.Connection = Connection;
module.exports.JsHeaderProvider = JsHeaderProvider;
module.exports.Index = Index;
module.exports.RecordBatchIterator = RecordBatchIterator;
module.exports.NativeMergeInsertBuilder = NativeMergeInsertBuilder;
module.exports.PermutationBuilder = PermutationBuilder;
module.exports.permutationBuilder = permutationBuilder;
module.exports.Query = Query;
module.exports.VectorQuery = VectorQuery;
module.exports.TakeQuery = TakeQuery;
module.exports.JsFullTextQuery = JsFullTextQuery;
module.exports.Reranker = Reranker;
module.exports.RrfReranker = RrfReranker;
module.exports.Session = Session;
module.exports.Table = Table;
module.exports.TagContents = TagContents;
module.exports.Tags = Tags;
